/*
 * Decompiled with CFR 0.152.
 */
package org.gotext;

import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import org.gotext.Service;
import org.gotext.Utils;
import org.gotext.goText;

public class Message {
    static final String RNSAVED = "_messages";
    static final String RNAUTO = "_autosaved_message";
    static final String RNSENT = "_last_messages";
    public static final int T_NEW = 0;
    public static final int T_SAVED = 1;
    public static final int T_SENT = 2;
    public static final int T_AUTOSAVEDLAST = 3;
    public static final int ID_AUTOSAVED = 1;
    public final int MAX_MEM_MESSAGES;
    private static final int EMPTY_MSG_RMSID = -10;
    private String token = ";";
    private String text;
    private String recipients;
    private long datetimeAsLong;
    private String messageString;
    private int recordStoreId;
    private int messageType;

    public Message() {
        this.MAX_MEM_MESSAGES = 10;
        this.text = "";
        this.recipients = "";
        this.messageString = "";
        this.messageType = 0;
        this.recordStoreId = -10;
        this.datetimeAsLong = 0L;
    }

    public Message(Message message) {
        this.MAX_MEM_MESSAGES = 10;
        this.text = message.text;
        this.recipients = message.recipients;
        this.messageString = message.messageString;
        this.messageType = message.messageType;
        this.recordStoreId = message.recordStoreId;
        this.datetimeAsLong = message.datetimeAsLong;
    }

    public Message(String string, int n, int n2) {
        this.MAX_MEM_MESSAGES = 10;
        this.text = Utils.getTag(string, "t");
        this.recipients = Utils.getTag(string, "r");
        String string2 = Utils.getTag(string, "d");
        try {
            this.datetimeAsLong = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.datetimeAsLong = 0L;
        }
        this.messageString = string;
        this.messageType = n;
        this.recordStoreId = n2;
    }

    public int setText(String string) {
        this.text = string;
        return this.text.length();
    }

    private int setRecipients(String string) {
        this.recipients = string;
        return this.recipients.length();
    }

    public void setType(int n) {
        this.messageType = n;
    }

    public void resetRecipients() {
        this.recipients = "";
    }

    public int addNumericRecipient(String string) {
        if (string.length() < 1) {
            return -1;
        }
        if (this.getRecipients().equals("")) {
            try {
                if (string.startsWith("+")) {
                    Long.parseLong(string.substring(1));
                } else {
                    Long.parseLong(string);
                }
                return this.setRecipients(string);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        try {
            if (string.startsWith("+")) {
                Long.parseLong(string.substring(1));
                return this.setRecipients(this.getRecipients() + this.token + string);
            }
            Long.parseLong(string);
            return this.setRecipients(this.getRecipients() + this.token + goText.options.getDefPrefix() + string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int addEmailRecipient(String string) {
        if (string.indexOf("@") < 1) {
            return -1;
        }
        if (string.indexOf(".") < 2) {
            return -1;
        }
        if (this.getRecipients().equals("")) {
            return this.setRecipients(string);
        }
        return this.setRecipients(this.getRecipients() + this.token + string);
    }

    public String[] getRecipientsArray() {
        String[] stringArray = Utils.splitString(this.getRecipients(), this.token);
        return stringArray;
    }

    public String getText() {
        return this.text;
    }

    public long getDateTimeAsLong() {
        return this.datetimeAsLong;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public int getType() {
        return this.messageType;
    }

    public boolean isReadyToSend(Service service) {
        if (this.text.length() > 0 && this.text.length() <= service.getMaxCharsWithSign()) {
            if (this.recipients.length() > 0) {
                return true;
            }
            if (service.getIntConfig(8) == 0) {
                return true;
            }
        }
        return false;
    }

    public void setForService(Service service) {
        String[] stringArray = this.getRecipientsArray().length > service.getIntConfig(8) ? new String[service.getIntConfig(8)] : new String[this.getRecipientsArray().length];
        System.arraycopy(this.getRecipientsArray(), 0, stringArray, 0, stringArray.length);
        this.resetRecipients();
        for (int i = 0; i < stringArray.length; ++i) {
            if (service.getIntConfig(12) == 1) {
                this.addNumericRecipient(stringArray[i]);
                continue;
            }
            if (service.getIntConfig(12) == 0) {
                this.addEmailRecipient(stringArray[i]);
                continue;
            }
            if (service.getIntConfig(12) != 2 || this.addNumericRecipient(stringArray[i]) != -1) continue;
            this.addEmailRecipient(stringArray[i]);
        }
    }

    public int saveMessage() {
        String string = "<t>" + this.text + "</t><r>" + this.recipients + "</r><d>" + System.currentTimeMillis() + "</d>";
        if (this.messageType == 1) {
            return Message.modMessage(string, this.getRmsId(), 1);
        }
        if (Message.countMessages(this.messageType) < 10 && this.messageType == 0) {
            this.recordStoreId = Message.insMessage(string, 1);
            this.setType(1);
            return this.recordStoreId;
        }
        if (this.messageType == 2 && goText.options.getAutoSaveLast() > 0) {
            int n = Message.countMessages(2);
            if (n > 0) {
                Message message = Message.getNewestMessage(2);
                if (this.getText().equals(message.getText()) && this.getRecipients().equals(message.getRecipients())) {
                    return message.getRmsId();
                }
            }
            if (n < 10) {
                return Message.insMessage(string, 2);
            }
            Message.delOldestMessage(2);
            return Message.insMessage(string, 2);
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToAutoLast() {
        String string;
        if (goText.options.getAutoSaveLast() > 0 && Message.modMessage(string = "<t>" + this.text + "</t><r>" + this.recipients + "</r>", 1, 3) == -1) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)Message.getRnForType(3), (boolean)true);
                if (recordStore.getNumRecords() > 1) {
                    recordStore.closeRecordStore();
                    RecordStore.deleteRecordStore((String)RNAUTO);
                }
            }
            catch (RecordStoreException recordStoreException) {
            }
            finally {
                Message.insMessage(string, 3);
            }
        }
    }

    public int getRmsId() {
        return this.recordStoreId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Message[] messagesArray(int n) {
        RecordStore recordStore = null;
        int n2 = 0;
        Message[] messageArray = new Message[]{};
        try {
            int n3;
            recordStore = RecordStore.openRecordStore((String)Message.getRnForType(n), (boolean)true);
            n2 = recordStore.getNumRecords();
            if (n2 > 0) {
                messageArray = new Message[n2];
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
                n3 = 0;
                while (recordEnumeration.hasNextElement()) {
                    int n4 = recordEnumeration.nextRecordId();
                    messageArray[n3] = new Message(new String(recordStore.getRecord(n4)), n, n4);
                    ++n3;
                }
                recordEnumeration.destroy();
            }
            if (messageArray[0].datetimeAsLong < messageArray[messageArray.length - 1].datetimeAsLong) {
                int n5 = 0;
                n3 = messageArray.length - 1;
                while (n5 < messageArray.length) {
                    if (n5 < n3) {
                        Message message = messageArray[n5];
                        messageArray[n5] = messageArray[n3];
                        messageArray[n3] = message;
                    }
                    ++n5;
                    --n3;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {}
        }
        return messageArray;
    }

    public static boolean getLastAutoSavedMessage() {
        Message message = Message.getNewestMessage(3);
        if (message.getType() == 3) {
            message.setType(0);
            goText.last_message = message;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void eraseAutoSavedMessage() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RNAUTO, (boolean)true);
            recordStore.deleteRecord(1);
        }
        catch (RecordStoreException recordStoreException) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {}
        }
    }

    public static void eraseSentMessages() {
        try {
            RecordStore.deleteRecordStore((String)RNSENT);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countMessages(int n) {
        int n2;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)Message.getRnForType(n), (boolean)true);
            n2 = recordStore.getNumRecords();
        }
        catch (Exception exception) {
            n2 = -1;
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    private static boolean isValidMessageString(String string) {
        return string.indexOf("<t>") >= 0 && string.indexOf("</t>") >= 0 && string.indexOf("<r>") >= 0 && string.indexOf("</r>") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int insMessage(String string, int n) {
        int n2 = 0;
        RecordStore recordStore = null;
        if (Message.isValidMessageString(string)) {
            try {
                recordStore = RecordStore.openRecordStore((String)Message.getRnForType(n), (boolean)true);
                n2 = recordStore.addRecord(string.getBytes(), 0, string.getBytes().length);
            }
            catch (Exception exception) {
                n2 = -1;
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int modMessage(String string, int n, int n2) {
        int n3 = 0;
        RecordStore recordStore = null;
        if (Message.isValidMessageString(string)) {
            try {
                recordStore = RecordStore.openRecordStore((String)Message.getRnForType(n2), (boolean)true);
                recordStore.setRecord(n, string.getBytes(), 0, string.getBytes().length);
                n3 = n;
            }
            catch (Exception exception) {
                n3 = -1;
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
        return n3;
    }

    private static String getRnForType(int n) {
        if (n == 1) {
            return RNSAVED;
        }
        if (n == 2) {
            return RNSENT;
        }
        if (n == 3) {
            return RNAUTO;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delMessage() {
        int n = 0;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)Message.getRnForType(this.messageType), (boolean)false);
            recordStore.deleteRecord(this.getRmsId());
            n = this.getRmsId();
        }
        catch (Exception exception) {
            n = -1;
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delOldestMessage(int n) {
        RecordStore recordStore = null;
        Message message = Message.getOldestNewestMessage(n, false);
        if (message.getRmsId() != -10 && message.getType() != 0) {
            try {
                recordStore = RecordStore.openRecordStore((String)Message.getRnForType(n), (boolean)false);
                recordStore.deleteRecord(message.getRmsId());
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Message getNewestMessage(int n) {
        return Message.getOldestNewestMessage(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Message getOldestNewestMessage(int n, boolean bl) {
        RecordStore recordStore = null;
        RecordEnumeration recordEnumeration = null;
        Message message = new Message();
        Message message2 = new Message();
        int n2 = 0;
        try {
            try {
                recordStore = RecordStore.openRecordStore((String)Message.getRnForType(n), (boolean)false);
                recordEnumeration = recordStore.enumerateRecords(null, null, true);
                while (recordEnumeration.hasNextElement()) {
                    int n3 = recordEnumeration.nextRecordId();
                    if (n2 == 0) {
                        message = new Message(new String(recordStore.getRecord(n3)), n, n3);
                    } else {
                        message2 = new Message(new String(recordStore.getRecord(n3)), n, n3);
                        if (bl && message2.datetimeAsLong > message.datetimeAsLong) {
                            message = message2;
                        } else if (!bl && message2.datetimeAsLong < message.datetimeAsLong) {
                            message = message2;
                        }
                    }
                    ++n2;
                }
                recordEnumeration.destroy();
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return message;
    }

    public static Message[] generateMessagesArray(int n) {
        return Message.messagesArray(n);
    }
}

