/*
 * Decompiled with CFR 0.152.
 */
package org.gotext;

import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import org.gotext.ConnectionManager;
import org.gotext.Service;
import org.gotext.Utils;
import org.gotext.goText;

public class ListModServices
extends List
implements CommandListener,
Utils.ConfirmationScreenSupporter {
    private Command command_back;
    private Command command_new;
    private Command command_del;
    private Command command_mod;
    private Command command_update;
    private Command command_up;
    private Command command_down;
    private Command command_default;
    private Command command_duplicate;
    private int CONFIRMATION_DELETE_SERVICE = 0;
    private int MAX_SVC_NAME_LEN = 16;

    public ListModServices() {
        super("", 3);
        this.start();
    }

    private void start() {
        this.setTitle("Services: " + goText.services.length);
        if (goText.services.length == 0) {
            this.setTicker(new Ticker("No services. Press NEW to set a new one."));
        } else {
            Image image = null;
            Image image2 = null;
            try {
                image = Image.createImage((String)"/img/ok.png");
                image2 = Image.createImage((String)"/img/no.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 0; i < goText.services.length; ++i) {
                if (goText.services[i].isConfigured()) {
                    if (goText.services[i].getIntConfig(18) == 1) {
                        this.append("(D) " + goText.services[i].getStringConfig(0), image);
                        continue;
                    }
                    this.append(goText.services[i].getStringConfig(0), image);
                    continue;
                }
                this.append(goText.services[i].getStringConfig(0), image2);
            }
        }
        this.command_new = new Command("New", 1, 1);
        this.command_mod = new Command("Modify", 1, 2);
        this.command_update = new Command("Update", 1, 3);
        this.command_del = new Command("Erase", 1, 4);
        this.command_up = new Command("Up", 1, 5);
        this.command_down = new Command("Down", 1, 6);
        this.command_default = new Command("Default", 1, 7);
        this.command_duplicate = new Command("Duplicate", 1, 8);
        this.command_back = new Command("Back", 2, 9);
        if (goText.services.length < 20) {
            this.addCommand(this.command_new);
        }
        this.addCommand(this.command_mod);
        this.addCommand(this.command_update);
        this.addCommand(this.command_del);
        this.addCommand(this.command_up);
        this.addCommand(this.command_down);
        this.addCommand(this.command_default);
        this.addCommand(this.command_duplicate);
        this.addCommand(this.command_back);
        this.setCommandListener(this);
        this.show();
    }

    public void show() {
        goText.display.setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND || command == this.command_mod) {
            if (this.getSelectedIndex() >= 0) {
                new FormModService(goText.services[this.getSelectedIndex()]);
            }
        } else if (command == this.command_back) {
            goText.mc.show();
        } else if (command == this.command_update) {
            if (this.getSelectedIndex() >= 0) {
                new FormUpdateService(goText.services[this.getSelectedIndex()]);
            }
        } else if (command == this.command_new) {
            new FormNewService();
        } else if (command == this.command_up) {
            if (goText.options.getServiceOrdering() == 0) {
                try {
                    Service.switchServicePosition(goText.services[this.getSelectedIndex()], goText.services[this.getSelectedIndex() - 1]);
                    new ListModServices();
                }
                catch (Exception exception) {}
            } else {
                int n;
                int n2;
                if (this.getSelectedIndex() - 1 >= 0) {
                    n2 = this.getSelectedIndex() - 1;
                    n = this.getSelectedIndex();
                } else {
                    n2 = -1;
                    n = this.getSelectedIndex();
                }
                Service.ServiceSwitcherAlt serviceSwitcherAlt = new Service.ServiceSwitcherAlt(n2, n);
                Utils.WaitProgressScreen waitProgressScreen = new Utils.WaitProgressScreen(serviceSwitcherAlt, "services are being reordered.");
                serviceSwitcherAlt.setWaitScreen(waitProgressScreen);
            }
        } else if (command == this.command_down) {
            if (goText.options.getServiceOrdering() == 0) {
                try {
                    Service.switchServicePosition(goText.services[this.getSelectedIndex()], goText.services[this.getSelectedIndex() + 1]);
                    new ListModServices();
                }
                catch (Exception exception) {}
            } else {
                int n;
                int n3;
                if (this.getSelectedIndex() < this.size() - 1) {
                    n3 = this.getSelectedIndex();
                    n = this.getSelectedIndex() + 1;
                } else {
                    n3 = this.getSelectedIndex();
                    n = -1;
                }
                Service.ServiceSwitcherAlt serviceSwitcherAlt = new Service.ServiceSwitcherAlt(n3, n);
                Utils.WaitProgressScreen waitProgressScreen = new Utils.WaitProgressScreen(serviceSwitcherAlt, "services are being reordered.");
                serviceSwitcherAlt.setWaitScreen(waitProgressScreen);
            }
        } else if (command == this.command_default) {
            try {
                if (goText.services[this.getSelectedIndex()].getIntConfig(18) == 1) {
                    Service.resetDefaultService();
                } else {
                    Service.resetDefaultService();
                    goText.services[this.getSelectedIndex()].setDefault(true);
                }
                new ListModServices();
            }
            catch (Exception exception) {}
        } else if (command == this.command_duplicate) {
            if (this.getSelectedIndex() >= 0) {
                Service service = goText.services[this.getSelectedIndex()];
                String string = service.getStringConfig(0);
                try {
                    string = string.substring(0, this.MAX_SVC_NAME_LEN - 2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                int n = 1;
                while (Service.existServiceName(n + string)) {
                    ++n;
                }
                string = n + string;
                int n4 = Service.insServiceConfig(string, service.getStringConfig(1), service.getStringConfig(2), service.getStringConfig(4), service.getStringConfig(6), service.getStringConfig(8), service.getStringConfig(9), service.getStringConfig(10), service.getStringConfig(12), service.getStringConfig(14), service.getStringConfig(15), service.getStringConfig(16), service.getStringConfig(17), service.getStringConfig(20));
                if (n4 < 0) {
                    Utils.popup("Error", "Error while inserting service (err:" + n4 + ")", AlertType.ERROR);
                } else {
                    new ListModServices();
                }
            }
        } else if (command == this.command_del && this.getSelectedIndex() >= 0) {
            new Utils.ConfirmationAlert(this, "Are you sure you want to delete the following service:" + goText.services[this.getSelectedIndex()].getStringConfig(0) + "?", this.CONFIRMATION_DELETE_SERVICE);
        }
    }

    public void doOk(int n) {
        if (n == this.CONFIRMATION_DELETE_SERVICE) {
            Service.delService(goText.services[this.getSelectedIndex()].getRmsId());
            new ListModServices();
        }
    }

    public void doKo(int n) {
        if (n == this.CONFIRMATION_DELETE_SERVICE) {
            this.show();
        }
    }

    private class ConfigGetter
    extends ConnectionManager {
        private String name;
        private String address;
        private Service s;
        private int mode = -1;
        private Form caller;
        static final int M_NEW = 0;
        static final int M_UPDATE = 1;
        private static final String configRequest = "action=config";

        public ConfigGetter(String string, String string2, Form form) {
            super(configRequest, string2);
            this.name = string;
            this.address = string2;
            this.mode = 0;
            this.caller = form;
        }

        public ConfigGetter(Service service, Form form) {
            super(configRequest, service.getStringConfig(1));
            this.name = service.getStringConfig(0);
            this.address = service.getStringConfig(1);
            this.mode = 1;
            this.s = service;
            this.caller = form;
        }

        protected void checkAnswer(String string) {
            String string2 = Utils.getTag(string, "config");
            if (string2.length() > 0) {
                String string3 = Utils.getTag(string2, "t");
                String string4 = Utils.getTag(string2, "nu");
                String string5 = Utils.getTag(string2, "np");
                String string6 = Utils.getTag(string2, "nn");
                String string7 = Utils.getTag(string2, "mr");
                String string8 = Utils.getTag(string2, "mc");
                String string9 = Utils.getTag(string2, "mm");
                String string10 = Utils.getTag(string2, "in");
                String string11 = Utils.getTag(string2, "xc");
                String string12 = Utils.getTag(string2, "sc");
                String string13 = Utils.getTag(string2, "cm");
                String string14 = Utils.getTag(string2, "cf");
                String string15 = Utils.getTag(string2, "mmm");
                if (string9.equals("")) {
                    string9 = "0";
                }
                if (string15.equals("")) {
                    string15 = "0";
                }
                int n = -1;
                if (this.mode == 0) {
                    n = Service.insServiceConfig(this.name, this.address, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15);
                } else if (this.mode == 1) {
                    n = this.s.set(this.name, this.address, Integer.parseInt(string4), this.s.getStringConfig(3), Integer.parseInt(string5), this.s.getStringConfig(5), Integer.parseInt(string6), this.s.getStringConfig(7), Integer.parseInt(string7), Integer.parseInt(string8), Integer.parseInt(string9), this.s.getIntConfig(11), Integer.parseInt(string10), this.s.getStringConfig(13), string11, string12, string13, string14, this.s.getIntConfig(18), this.s.getStringConfig(19), Integer.parseInt(string15), this.s.getIntConfig(21));
                }
                if (n > 0) {
                    this.caller.append("Operation successful!\n");
                    if (string3.length() > 0) {
                        string3 = "Message from service :\n" + string3;
                    }
                    Utils.popup("OK", "Inserted service!\n" + string3, AlertType.INFO);
                } else {
                    this.caller.append("Operation non completed.\n");
                    Utils.popup("Error", "Error while inserting service (err:" + n + ")", AlertType.ERROR);
                }
            } else {
                int n = -3;
                try {
                    n = Integer.parseInt(Utils.getTag(string, "num"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.caller.append("Operation non completed.\n(Error: " + Utils.getTag(string, "txt") + ")");
                switch (n) {
                    case -2: {
                        Utils.popup("Error", "Error in service answer.", AlertType.ERROR);
                        break;
                    }
                    case -1: {
                        Utils.popup("Error", "GPRS error: it was not possible to do the connection", AlertType.ERROR);
                        break;
                    }
                    default: {
                        Utils.popup("Error", "Unknow error", AlertType.ERROR);
                    }
                }
            }
        }

        protected void showScreen() {
        }

        protected void setProgressText(String string, int n) {
        }

        protected void setCookieToStore(String string) {
        }

        protected String getStoredCookie() {
            return "";
        }
    }

    public class FormNewService
    extends Form
    implements CommandListener {
        private Command command_back;
        private Command command_ins;
        private TextField textfield_servicename;
        private TextField textfield_serviceaddress;
        private boolean isFirstInsert = true;

        public FormNewService() {
            super("New service");
            this.start();
        }

        private void start() {
            this.textfield_servicename = new TextField("Name :", "", ListModServices.this.MAX_SVC_NAME_LEN, 0);
            this.textfield_serviceaddress = new TextField("URL :", "http://", 255, 4);
            this.append((Item)this.textfield_servicename);
            this.append((Item)this.textfield_serviceaddress);
            this.command_ins = new Command("Insert", 1, 1);
            this.command_back = new Command("Back", 2, 2);
            this.addCommand(this.command_ins);
            this.addCommand(this.command_back);
            this.setCommandListener(this);
            this.show();
        }

        public void show() {
            goText.display.setCurrent((Displayable)this);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.command_back) {
                new ListModServices();
            } else if (command == this.command_ins) {
                if (Service.existServiceName(this.textfield_servicename.getString())) {
                    Utils.popup("Warning", "Service Name already in use", AlertType.WARNING);
                } else {
                    if (!this.isFirstInsert) {
                        this.delete(this.size() - 1);
                        this.delete(this.size() - 1);
                    }
                    this.isFirstInsert = false;
                    this.append("Wait while connecting to the server to download configuration file!\n");
                    ConfigGetter configGetter = new ConfigGetter(this.textfield_servicename.getString(), this.textfield_serviceaddress.getString(), this);
                    new Thread(configGetter).start();
                }
            }
        }
    }

    public class FormUpdateService
    extends Form
    implements CommandListener {
        private Command command_back;
        private Service s;

        public FormUpdateService(Service service) {
            super(service.getStringConfig(0));
            this.s = service;
            this.command_back = new Command("Back", 2, 2);
            this.addCommand(this.command_back);
            this.setCommandListener(this);
            this.start();
        }

        private void start() {
            this.append("Wait while connecting to the server to download configuration file!\n");
            this.show();
            ConfigGetter configGetter = new ConfigGetter(this.s, this);
            new Thread(configGetter).start();
        }

        public void show() {
            goText.display.setCurrent((Displayable)this);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.command_back) {
                new ListModServices();
            }
        }
    }

    public class FormModService
    extends Form
    implements CommandListener {
        private Service s;
        private Command command_back;
        private Command command_app;
        private TextField textfield_name;
        private TextField textfield_user;
        private TextField textfield_pass;
        private TextField textfield_nick;
        private TextField textfield_sign;
        private StringItem stringitem_address;
        transient String old_name;

        public FormModService(Service service) {
            super("Services configuration");
            this.s = service;
            this.old_name = service.getStringConfig(0);
            this.start();
        }

        private void start() {
            String string = "(required)";
            String string2 = "(optional)";
            this.textfield_name = new TextField("Service name: ", this.s.getStringConfig(0), ListModServices.this.MAX_SVC_NAME_LEN, 0);
            this.stringitem_address = new StringItem("URL :", this.s.getStringConfig(1));
            this.textfield_user = new TextField("User " + (this.s.getIntConfig(2) == 1 ? string : string2) + ":", this.s.getStringConfig(3), 30, 0);
            this.textfield_pass = new TextField("Pass " + (this.s.getIntConfig(4) == 1 ? string : string2) + ":", this.s.getStringConfig(5), 30, 65536);
            this.textfield_nick = new TextField("Nick " + (this.s.getIntConfig(6) == 1 ? string : string2) + ":", this.s.getStringConfig(7), 256, 0);
            this.textfield_sign = new TextField("Sign (optional):", this.s.getStringConfig(13), 30, 0);
            this.append((Item)this.textfield_name);
            this.append((Item)this.stringitem_address);
            if (this.s.getIntConfig(2) > 0) {
                this.append((Item)this.textfield_user);
            }
            if (this.s.getIntConfig(4) > 0) {
                this.append((Item)this.textfield_pass);
            }
            if (this.s.getIntConfig(6) > 0) {
                this.append((Item)this.textfield_nick);
            }
            this.append((Item)this.textfield_sign);
            this.command_app = new Command("Apply", 1, 1);
            this.command_back = new Command("Back", 2, 2);
            this.addCommand(this.command_app);
            this.addCommand(this.command_back);
            this.setCommandListener(this);
            this.show();
        }

        public void show() {
            goText.display.setCurrent((Displayable)this);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.command_back) {
                new ListModServices();
            } else if (command == this.command_app) {
                if (!this.old_name.equals(this.textfield_name.getString()) && Service.existServiceName(this.textfield_name.getString())) {
                    Utils.popup("Warning", "Service Name already in use", AlertType.WARNING);
                } else {
                    this.s.set(this.textfield_name.getString(), this.s.getStringConfig(1), this.s.getIntConfig(2), this.textfield_user.getString(), this.s.getIntConfig(4), this.textfield_pass.getString(), this.s.getIntConfig(6), this.textfield_nick.getString(), this.s.getIntConfig(8), this.s.getIntConfig(9), this.s.getIntConfig(10), this.s.getIntConfig(11), this.s.getIntConfig(12), this.textfield_sign.getString(), this.s.getStringConfig(14), this.s.getStringConfig(15), this.s.getStringConfig(16), this.s.getStringConfig(17), this.s.getIntConfig(18), "", this.s.getIntConfig(20), this.s.getIntConfig(21));
                    new ListModServices();
                }
            }
        }
    }
}

