/*
 * Decompiled with CFR 0.152.
 */
package org.gotext;

import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import org.gotext.Contact;
import org.gotext.Utils;
import org.gotext.goText;

public class ListModContacts
extends List
implements CommandListener {
    private static final int MAX_GROUP = 5;
    private Command command_back;
    private Command command_new_c;
    private Command command_new_g;
    private Command command_del;
    private Command command_mod;

    public ListModContacts() {
        super("", 3);
        this.setTitle("Contacts");
        this.start();
    }

    private void start() {
        this.setTitle("Contacts: " + goText.contacts.length);
        if (goText.contacts.length == 0) {
            this.setTicker(new Ticker("No contacts. Press NEW to insert a new contact"));
        } else {
            Image image = null;
            Image image2 = null;
            try {
                image = Image.createImage((String)"/img/contact.png");
                image2 = Image.createImage((String)"/img/group.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 0; i < goText.contacts.length; ++i) {
                if (goText.contacts[i].isGroup()) {
                    this.append(goText.contacts[i].getName(), image2);
                    continue;
                }
                this.append(goText.contacts[i].getName(), image);
            }
        }
        this.command_new_c = new Command("New contact", 1, 1);
        this.command_new_g = new Command("New group", 1, 2);
        this.command_mod = new Command("Modify", 1, 3);
        this.command_del = new Command("Erase", 1, 4);
        this.command_back = new Command("Back", 2, 5);
        if (goText.contacts.length < 30) {
            this.addCommand(this.command_new_c);
        }
        if (goText.contacts.length < 30) {
            this.addCommand(this.command_new_g);
        }
        this.addCommand(this.command_mod);
        this.addCommand(this.command_del);
        this.addCommand(this.command_back);
        this.setCommandListener(this);
        this.show();
    }

    public void show() {
        goText.display.setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND || command == this.command_mod) {
            if (this.getSelectedIndex() >= 0) {
                if (goText.contacts[this.getSelectedIndex()].isGroup()) {
                    new FormModInsertGroup(goText.contacts[this.getSelectedIndex()]);
                } else {
                    new FormModInsertContact(goText.contacts[this.getSelectedIndex()]);
                }
            }
        } else if (command == this.command_back) {
            goText.mc.show();
        } else if (command == this.command_new_c) {
            new FormModInsertContact();
        } else if (command == this.command_new_g) {
            new FormModInsertGroup();
        } else if (command == this.command_del && this.getSelectedIndex() >= 0) {
            Contact.delContact(goText.contacts[this.getSelectedIndex()].getRmsId());
            new ListModContacts();
        }
    }

    public class FormModInsertGroup
    extends Form
    implements CommandListener {
        private Command command_back;
        private Command command_ok;
        private TextField textfield_name;
        private TextField[] textfield_number;
        private boolean isNewContact;
        private Contact contact;

        public FormModInsertGroup() {
            super("Insert groups");
            String string = "";
            for (int i = 0; i < 4; ++i) {
                string = string + ";";
            }
            this.contact = new Contact("<nu>" + string + "</nu>");
            this.isNewContact = true;
            this.start();
        }

        public FormModInsertGroup(Contact contact) {
            super("Modify group");
            this.contact = contact;
            this.isNewContact = false;
            this.start();
        }

        private void start() {
            int n;
            this.textfield_name = new TextField("Name :", "", 20, 0);
            if (!this.isNewContact) {
                this.textfield_name.setString(this.contact.getName());
            }
            this.append((Item)this.textfield_name);
            String[] stringArray = Utils.splitString(this.contact.getNumber(), ";");
            this.textfield_number = new TextField[5];
            for (n = 0; n < stringArray.length; ++n) {
                this.textfield_number[n] = new TextField("Number :".substring(0, "Number :".length() - 1) + "" + n + ":", stringArray[n], 14, 3);
                this.append((Item)this.textfield_number[n]);
            }
            for (n = stringArray.length; n < this.textfield_number.length; ++n) {
                this.textfield_number[n] = new TextField("Number :".substring(0, "Number :".length() - 1) + "" + n + ":", "", 14, 3);
                this.append((Item)this.textfield_number[n]);
            }
            this.command_ok = this.isNewContact ? new Command("Insert", 1, 1) : new Command("Apply", 1, 1);
            this.command_back = new Command("Back", 2, 1);
            this.addCommand(this.command_ok);
            this.addCommand(this.command_back);
            this.setCommandListener(this);
            this.show();
        }

        public void show() {
            goText.display.setCurrent((Displayable)this);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.command_back) {
                ListModContacts.this.show();
            } else if (command == this.command_ok) {
                int n;
                String string = "";
                for (n = 0; n < 5; ++n) {
                    if (this.textfield_number[n].getString().length() <= 0) continue;
                    string = string + this.textfield_number[n].getString() + ";";
                }
                if (string.endsWith(";")) {
                    string = string.substring(0, string.length() - 1);
                }
                n = -1;
                n = this.isNewContact ? Contact.insert(this.textfield_name.getString(), string, "") : this.contact.set(this.textfield_name.getString(), string, "");
                switch (n) {
                    case -2: {
                        Utils.popup("Warning", "Name already in use", AlertType.WARNING);
                        break;
                    }
                    case -1: {
                        Utils.popup("Error", "Error while inserting into db", AlertType.ERROR);
                        break;
                    }
                    case 0: {
                        Utils.popup("Warning", "There aren't enough data", AlertType.WARNING);
                        break;
                    }
                    default: {
                        new ListModContacts();
                    }
                }
            }
        }
    }

    public class FormModInsertContact
    extends Form
    implements CommandListener {
        private Command command_back;
        private Command command_ok;
        private TextField textfield_name;
        private TextField textfield_email;
        private TextField textfield_number;
        private boolean isNewContact;
        private Contact contact;

        public FormModInsertContact() {
            super("Insert contact");
            this.contact = null;
            this.isNewContact = true;
            this.start();
        }

        public FormModInsertContact(Contact contact) {
            super("Modify contact");
            this.contact = contact;
            this.isNewContact = false;
            this.start();
        }

        private void start() {
            this.textfield_name = new TextField("Name :", "", 20, 0);
            this.textfield_number = new TextField("Number :", "", 14, 3);
            this.textfield_email = new TextField("Email : :", "", 50, 1);
            if (!this.isNewContact) {
                this.textfield_name.setString(this.contact.getName());
                this.textfield_number.setString(this.contact.getNumber());
                this.textfield_email.setString(this.contact.getEmail());
            }
            this.append((Item)this.textfield_name);
            this.append((Item)this.textfield_number);
            this.append((Item)this.textfield_email);
            this.command_ok = this.isNewContact ? new Command("Insert", 1, 1) : new Command("Apply", 1, 1);
            this.command_back = new Command("Back", 2, 1);
            this.addCommand(this.command_ok);
            this.addCommand(this.command_back);
            this.setCommandListener(this);
            this.show();
        }

        public void show() {
            goText.display.setCurrent((Displayable)this);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.command_back) {
                ListModContacts.this.show();
            } else if (command == this.command_ok) {
                int n = -1;
                n = this.isNewContact ? Contact.insert(this.textfield_name.getString(), this.textfield_number.getString(), this.textfield_email.getString()) : this.contact.set(this.textfield_name.getString(), this.textfield_number.getString(), this.textfield_email.getString());
                switch (n) {
                    case -2: {
                        Utils.popup("Warning", "Name already in use", AlertType.WARNING);
                        break;
                    }
                    case -1: {
                        Utils.popup("Error", "Error while inserting into db", AlertType.ERROR);
                        break;
                    }
                    case 0: {
                        Utils.popup("Warning", "There aren't enough data", AlertType.WARNING);
                        break;
                    }
                    default: {
                        new ListModContacts();
                    }
                }
            }
        }
    }
}

