/*
 * Decompiled with CFR 0.152.
 */
package org.gotext;

import java.io.IOException;
import java.util.Date;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.Ticker;
import org.gotext.FormCompose;
import org.gotext.ListSelectService;
import org.gotext.Message;
import org.gotext.Service;
import org.gotext.Utils;
import org.gotext.goText;

public class ListMessages
extends List
implements CommandListener {
    protected Service s;
    private Command command_back;

    public ListMessages(Service service) {
        super("", 3);
        this.s = service;
        this.setTitle("[" + service.getRemainingMsgString() + "]" + service.getStringConfig(0));
        this.start();
    }

    private void start() {
        String[] stringArray = new String[]{"New", "Saved"};
        Image[] imageArray = null;
        Image image = null;
        Image image2 = null;
        try {
            image = Image.createImage((String)"/img/new.png");
            image2 = Image.createImage((String)"/img/saved.png");
            imageArray = new Image[]{image, image2};
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (imageArray != null && imageArray.length > 0) {
                this.append(stringArray[i], imageArray[i]);
                continue;
            }
            this.append(stringArray[i], null);
        }
        if (goText.options.getAutoSaveLast() == 1) {
            Image image3 = null;
            try {
                image3 = Image.createImage((String)"/img/sentlist.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.append("Sent", image3);
        }
        Message.getLastAutoSavedMessage();
        if (goText.last_message != null) {
            Image image4 = null;
            try {
                image4 = Image.createImage((String)"/img/last.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.append("Last", image4);
        }
        this.command_back = new Command("Back", 2, 1);
        this.addCommand(this.command_back);
        this.setCommandListener(this);
        this.show();
    }

    public void show() {
        goText.display.setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND) {
            switch (this.getSelectedIndex()) {
                case 0: {
                    new FormCompose(this.s, new Message());
                    break;
                }
                case 1: {
                    new ListSavedMessages(1);
                    break;
                }
                case 2: {
                    if (goText.options.getAutoSaveLast() == 1) {
                        new ListSavedMessages(2);
                        break;
                    }
                    new FormCompose(this.s, new Message(goText.last_message));
                    break;
                }
                case 3: {
                    new FormCompose(this.s, new Message(goText.last_message));
                }
            }
        } else if (command == this.command_back) {
            new ListSelectService();
        }
    }

    public class ListSavedMessages
    extends List
    implements CommandListener,
    Utils.ConfirmationScreenSupporter {
        private Command command_back;
        private Command command_del;
        private Command command_sel;
        private int messageType;
        private Message[] messages;
        static final int CONFIRMATION_DELETE_MESSAGE = 0;

        public ListSavedMessages(int n) {
            super("", 3);
            this.messageType = n;
            this.start();
        }

        private void start() {
            this.messages = Message.generateMessagesArray(this.messageType);
            String string = "";
            if (this.messageType == 1) {
                string = "Saved";
            } else if (this.messageType == 2) {
                string = "Sent";
            }
            this.setTitle(string + " " + this.messages.length);
            if (this.messages.length == 0) {
                this.setTicker(new Ticker("No saved messages"));
            } else {
                for (int i = 0; i < this.messages.length; ++i) {
                    String string2 = this.messages[i].getText();
                    if (string2.length() > 30) {
                        this.append(string2.substring(0, 28) + "..", null);
                        continue;
                    }
                    this.append(string2, null);
                }
            }
            this.command_sel = new Command("Select", 1, 1);
            this.command_del = new Command("Erase", 1, 2);
            this.command_back = new Command("Back", 2, 3);
            this.addCommand(this.command_sel);
            this.addCommand(this.command_del);
            this.addCommand(this.command_back);
            this.setCommandListener(this);
            this.show();
        }

        public void show() {
            goText.display.setCurrent((Displayable)this);
        }

        public void commandAction(Command command, Displayable displayable) {
            int n = this.getSelectedIndex();
            if (command == List.SELECT_COMMAND || command == this.command_sel) {
                if (n >= 0) {
                    Message message = new Message(this.messages[n]);
                    if (message.getType() == 2) {
                        message.setType(0);
                    }
                    new FormMessageInfo(this, message);
                }
            } else if (command == this.command_back) {
                ListMessages.this.show();
            } else if (command == this.command_del && n >= 0 && n >= 0) {
                new Utils.ConfirmationAlert(this, "Are you sure you want to delete the following message?\n" + this.messages[n].getText(), 0);
            }
        }

        public void doOk(int n) {
            if (n == 0) {
                this.messages[this.getSelectedIndex()].delMessage();
                this.messages = null;
                new ListSavedMessages(this.messageType);
            }
        }

        public void doKo(int n) {
            if (n == 0) {
                this.show();
            }
        }

        public class FormMessageInfo
        extends Form
        implements CommandListener {
            private ListSavedMessages lsmCaller;
            protected StringItem si_rcpt;
            protected StringItem si_text;
            protected DateField df_time;
            private Message msgToDisplay;
            private Command command_send;
            private Command command_back;

            public FormMessageInfo(ListSavedMessages listSavedMessages2, Message message) {
                super("Info");
                this.lsmCaller = listSavedMessages2;
                this.msgToDisplay = message;
                this.start();
            }

            private void start() {
                if (this.msgToDisplay.getRecipients().length() > 0) {
                    this.si_rcpt = new StringItem("Recipients:\n", this.msgToDisplay.getRecipients() + "\n");
                    this.append((Item)this.si_rcpt);
                }
                if (this.msgToDisplay.getDateTimeAsLong() > 0L) {
                    this.df_time = new DateField("Date:", 3);
                    this.df_time.setDate(new Date(this.msgToDisplay.getDateTimeAsLong()));
                    this.append((Item)this.df_time);
                }
                this.si_text = new StringItem("Text:", this.msgToDisplay.getText());
                this.append((Item)this.si_text);
                this.command_send = new Command("Send", 1, 1);
                this.command_back = new Command("Back", 2, 2);
                this.addCommand(this.command_send);
                this.addCommand(this.command_back);
                this.setCommandListener(this);
                this.show();
            }

            public void show() {
                goText.display.setCurrent((Displayable)this);
            }

            public void commandAction(Command command, Displayable displayable) {
                if (command == this.command_back) {
                    this.lsmCaller.show();
                } else if (command == this.command_send) {
                    new FormCompose(((ListSavedMessages)ListSavedMessages.this).ListMessages.this.s, this.msgToDisplay);
                }
            }
        }
    }
}

