/*
 * Decompiled with CFR 0.152.
 */
package org.gotext;

import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import org.gotext.ConnectionManager;
import org.gotext.ListMessages;
import org.gotext.ListSelectService;
import org.gotext.Message;
import org.gotext.Service;
import org.gotext.Utils;
import org.gotext.goText;

public class FormSend
extends Form
implements CommandListener,
Utils.ConfirmationScreenSupporter {
    protected Service s;
    protected Message m;
    protected StringItem si_status;
    protected StringItem si_in;
    protected StringItem si_out;
    protected ImageItem imgitem;
    protected TextField textfield_imgcode;
    private Command command_back;
    private Command command_ok;
    protected String address;
    protected String datastring;
    protected String storedcookie;
    private SendThread sendThread;
    static final int CONFIRMATION_GO_BACK = 0;

    public FormSend(Service service, Message message) {
        super("");
        this.s = service;
        this.m = message;
        this.storedcookie = service.getStringConfig(19);
        this.setTitle("Sending");
        this.address = service.getStringConfig(1);
        this.datastring = "";
        this.imgitem = null;
        this.start();
    }

    private void start() {
        this.m.setType(2);
        this.m.saveMessage();
        this.datastring = this.datastring + "user=" + this.s.getStringConfig(3) + "&";
        this.datastring = this.datastring + "pass=" + this.s.getStringConfig(5) + "&";
        this.datastring = this.datastring + "nick=" + Utils.checkText(this.s.getStringConfig(7)) + "&";
        this.datastring = this.datastring + "rcpt=" + Utils.checkText(this.m.getRecipients()) + "&";
        this.datastring = this.s.getStringConfig(13).length() > 0 ? this.datastring + "text=" + Utils.checkText(this.m.getText() + "\n" + this.s.getStringConfig(13)) : this.datastring + "text=" + Utils.checkText(this.m.getText());
        this.si_status = new StringItem("Status: ", "Wait\n");
        this.append((Item)this.si_status);
        this.si_out = new StringItem("Out: ", "0 b\n");
        this.append((Item)this.si_out);
        this.si_in = new StringItem("In: ", "0 b\n");
        this.append((Item)this.si_in);
        this.sendThread = new SendThread(this.datastring, this.address, this.storedcookie);
        new Thread(this.sendThread).start();
        this.textfield_imgcode = new TextField("ImageCode", "", 20, 0);
        this.command_back = new Command("Back", 2, 2);
        this.command_ok = new Command("Send", 4, 1);
        this.addCommand(this.command_back);
        this.setCommandListener(this);
        this.show();
    }

    public void show() {
        goText.display.setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.command_back) {
            if (this.sendThread != null && !this.sendThread.isSendFinished()) {
                new Utils.ConfirmationAlert(this, "Message is still being sent.\nAre you sure you want to go back?", 0);
            } else {
                this.doOk(0);
            }
        }
        if (command == this.command_ok && this.textfield_imgcode.getString().compareTo("") != 0) {
            this.removeCommand(this.command_ok);
            Image image = Image.createImage((int)25, (int)15);
            image.getGraphics().drawString(".........", 0, 0, 0);
            this.imgitem.setImage(image);
            this.datastring = "ic=" + this.textfield_imgcode.getString();
            new Thread(new SendThread(this.datastring, this.address, this.storedcookie)).start();
        }
    }

    public void doOk(int n) {
        if (n == 0) {
            Utils.safeQuitAutoLastMessageSaver();
            if (Service.getDefaultService() != -1) {
                if (goText.services[Service.getDefaultService()].isConfigured()) {
                    new ListMessages(goText.services[Service.getDefaultService()]);
                } else {
                    new ListSelectService();
                }
            } else {
                new ListSelectService();
            }
        }
    }

    public void doKo(int n) {
        if (n == 0) {
            this.show();
        }
    }

    private class SendThread
    extends ConnectionManager {
        String localcookie;

        public SendThread(String string, String string2, String string3) {
            super(string, string2);
            this.localcookie = string3;
        }

        protected void handleReply(byte[] byArray, String string) {
            try {
                Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                this.showImage(image);
                FormSend.this.textfield_imgcode.setString("");
            }
            catch (Exception exception) {
                try {
                    if (FormSend.this.textfield_imgcode.getString().compareTo("") != 0) {
                        while (!FormSend.this.get(FormSend.this.size() - 1).equals(FormSend.this.textfield_imgcode)) {
                            FormSend.this.delete(FormSend.this.size() - 1);
                        }
                        FormSend.this.delete(FormSend.this.size() - 1);
                        FormSend.this.delete(FormSend.this.size() - 1);
                    }
                    if (byArray != null) {
                        string = new String(byArray);
                        goText.log(string);
                    }
                    this.checkAnswer(string);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }

        private void showImage(Image image) {
            if (FormSend.this.imgitem == null) {
                try {
                    FormSend.this.imgitem = new ImageItem("", image, 512, null);
                    FormSend.this.append((Item)FormSend.this.imgitem);
                    FormSend.this.append((Item)FormSend.this.textfield_imgcode);
                    FormSend.this.addCommand(FormSend.this.command_ok);
                }
                catch (Exception exception) {
                    goText.log("error making imgItem:" + exception.toString());
                }
                FormSend.this.show();
            } else {
                FormSend.this.imgitem.setImage(image);
                FormSend.this.addCommand(FormSend.this.command_ok);
            }
        }

        protected void checkAnswer(String string) {
            int n;
            int n2;
            int n3;
            int n4 = -1;
            int n5 = -1;
            String string2 = "";
            String string3 = Utils.getTag(string, "srm");
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                n3 = -1;
            }
            String string4 = Utils.getTag(string, "srmm");
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                n2 = -1;
            }
            String string5 = Utils.getTag(string, "num");
            try {
                if (string5.indexOf(",") != -1 && string5.indexOf("!") == string5.length() - 1) {
                    n5 = Integer.parseInt(string5.substring(string5.indexOf(",") + 1, string5.indexOf("!")));
                    string5 = string5.substring(0, string5.indexOf(","));
                } else if (string5.indexOf(",") != -1) {
                    n4 = Integer.parseInt(string5.substring(string5.indexOf(",") + 1));
                    string5 = string5.substring(0, string5.indexOf(","));
                }
                n = Integer.parseInt(string5);
            }
            catch (Exception exception) {
                n = -2;
            }
            string2 = Utils.getTag(string, "txt");
            FormSend.this.append(string2);
            FormSend.this.show();
            switch (n) {
                case -2: {
                    Utils.popup("Error", "Error in service answer.", AlertType.ERROR);
                    break;
                }
                case -1: {
                    Utils.popup("Error", "GPRS error: it was not possible to do the connection", AlertType.ERROR);
                    break;
                }
                case 0: {
                    if (n5 > 0) {
                        FormSend.this.s.increaseSentMsg(n5, FormSend.this.storedcookie);
                        goText.options.increaseCounter(n5);
                        Utils.popup("OK", "Text sent!", AlertType.INFO);
                        break;
                    }
                    if (n4 < 0) {
                        FormSend.this.s.increaseSentMsg(FormSend.this.m.getRecipientsArray().length, FormSend.this.storedcookie);
                        goText.options.increaseCounter(FormSend.this.m.getRecipientsArray().length);
                        Utils.popup("OK", "Text sent!", AlertType.INFO);
                        break;
                    }
                    FormSend.this.s.increaseSentMsg(n4, FormSend.this.storedcookie);
                    goText.options.increaseCounter(n4);
                    Utils.popup("Warning", "Warning: message not fully sent!", AlertType.WARNING);
                    break;
                }
                case 1: {
                    Utils.popup("Error", "Data error", AlertType.ERROR);
                    break;
                }
                case 2: {
                    Utils.popup("Error", "Login error", AlertType.ERROR);
                    break;
                }
                case 3: {
                    Utils.popup("Error", "Website error (" + FormSend.this.s.getStringConfig(0) + ")", AlertType.ERROR);
                    break;
                }
                default: {
                    Utils.popup("Error", "Unknow error: " + n, AlertType.ERROR);
                }
            }
            if (n3 >= 0) {
                FormSend.this.s.synchRemMsg(n3);
            }
            if (n2 >= 0) {
                FormSend.this.s.synchRemMonthlyMsg(n2);
            }
        }

        protected void showScreen() {
            if (FormSend.this.isShown()) {
                FormSend.this.show();
            }
        }

        protected void setProgressText(String string, int n) {
            switch (n) {
                case 0: {
                    FormSend.this.si_status.setText(string);
                    break;
                }
                case 1: {
                    FormSend.this.si_in.setText(string);
                    break;
                }
                case 2: {
                    FormSend.this.si_out.setText(string);
                }
            }
        }

        protected void setCookieToStore(String string) {
            FormSend.this.storedcookie = string;
            this.localcookie = string;
        }

        protected String getStoredCookie() {
            return this.localcookie;
        }
    }
}

