/*
 * Decompiled with CFR 0.152.
 */
package org.gotext;

import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import org.gotext.FormSend;
import org.gotext.Lang;
import org.gotext.ListMessages;
import org.gotext.Message;
import org.gotext.Service;
import org.gotext.Utils;
import org.gotext.goText;

public class FormCompose
extends TextBox
implements CommandListener,
Utils.ConfirmationScreenSupporter {
    public static final int ALLOWED_OVERSIZE = 50;
    static final int GOTEXT_MAX_TEXT_SIZE = 65535;
    static final int CONFIRMATION_OVERWRITE_MESSAGE = 1;
    private Message m;
    private Service s;
    private CharsCounter counterThread;
    private SubstituteChars subsThread;
    private int dev_max_chars;
    private int available_lastPart_chars;
    private int available_chars;
    static final int CONFIRMATION_CLEAR_MESSAGE = 0;
    private int current_max_chars;
    private Command command_ref;
    private Command command_compr;
    private Command command_send;
    private Command command_prev;
    private Command command_next;
    private Command command_back;
    private Command command_save;
    private boolean isLastPart = true;
    private int current_edited_partN;
    private int total_partN;
    private String previous_parts;
    private String next_parts;

    public FormCompose(Service service, Message message) {
        super("Write", "", 65535, 0);
        this.s = service;
        this.m = message;
        this.init();
        this.setPart(1);
        this.start();
    }

    private void init() {
        this.total_partN = 0;
        this.dev_max_chars = new DevMaxCharGetter().getDeviceMaxChar();
        this.available_chars = this.dev_max_chars - 50;
        if (this.s.getMaxCharsWithSign() > this.dev_max_chars) {
            int n = 1;
            while (this.available_chars * n < this.s.getMaxCharsWithSign()) {
                this.total_partN = n++;
            }
            ++this.total_partN;
            this.available_lastPart_chars = this.s.getMaxCharsWithSign() - this.available_chars * (this.total_partN - 1);
        } else {
            this.total_partN = 1;
            this.available_lastPart_chars = this.s.getMaxCharsWithSign();
        }
    }

    private void setPart(int n) {
        if (n < this.total_partN) {
            this.current_max_chars = this.available_chars + 50;
            this.isLastPart = false;
        } else {
            this.current_max_chars = this.available_lastPart_chars + 50;
            this.isLastPart = true;
        }
        this.current_edited_partN = n;
    }

    protected String getNext_parts() {
        return this.next_parts;
    }

    protected String getPrevious_parts() {
        return this.previous_parts;
    }

    private void start() {
        String string = "";
        this.setMaxSize(this.current_max_chars);
        this.available_chars = this.current_max_chars - 50;
        string = Utils.getTextPart(this.m, this.available_chars, this.current_edited_partN, this.total_partN, this.s);
        this.setString(string);
        int n = 0;
        n = !string.equals("") ? this.m.getText().indexOf(string) : this.m.getText().length();
        this.previous_parts = this.m.getText().substring(0, n);
        this.next_parts = !this.isLastPart ? this.m.getText().substring(n + string.length()) : "";
        this.removeCommand(this.command_send);
        this.removeCommand(this.command_next);
        this.removeCommand(this.command_prev);
        this.removeCommand(this.command_ref);
        this.removeCommand(this.command_compr);
        this.removeCommand(this.command_back);
        this.removeCommand(this.command_save);
        int n2 = 0;
        this.command_send = new Command("Send", 1, ++n2);
        this.addCommand(this.command_send);
        if (this.total_partN > 1 && this.current_edited_partN < this.total_partN) {
            this.command_next = new Command("Next", 1, ++n2);
            this.addCommand(this.command_next);
        }
        if (this.total_partN > 1 && this.current_edited_partN > 1) {
            this.command_prev = new Command("Previous", 1, ++n2);
            this.addCommand(this.command_prev);
        }
        this.command_back = new Command("Back", 2, ++n2);
        this.command_save = new Command("Save", 1, ++n2);
        this.command_compr = new Command("Text Compression", 1, ++n2);
        this.command_ref = new Command("Reset", 1, ++n2);
        this.addCommand(this.command_back);
        this.addCommand(this.command_save);
        this.addCommand(this.command_compr);
        this.addCommand(this.command_ref);
        this.setCommandListener(this);
        this.safeStartCharCounter();
        if (this.current_edited_partN == 1) {
            this.subsThread = new SubstituteChars();
            this.subsThread.start();
        }
        this.show();
        Utils.safeStartAutoLastMessageSaver(this, this.m);
    }

    public void show() {
        goText.display.setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.command_ref) {
            Utils.safeQuitAutoLastMessageSaver();
            new Utils.ConfirmationAlert(this, "Are you sure you want to clear the text?", 0);
        } else if (command == this.command_send) {
            Utils.safeQuitAutoLastMessageSaver();
            this.safeQuitCharCounter();
            this.m.setText(this.previous_parts + this.getString() + this.next_parts);
            new RecipientsForm();
        } else if (command == this.command_compr) {
            Utils.safeQuitAutoLastMessageSaver();
            this.m.setText((this.previous_parts + this.getString() + this.next_parts).trim());
            new FormCompressText();
        } else if (command == this.command_back) {
            goText.last_message = new Message(this.m);
            goText.last_message.saveToAutoLast();
            Utils.safeQuitAutoLastMessageSaver();
            this.safeQuitCharCounter();
            new ListMessages(this.s);
        } else if (command == this.command_save) {
            this.m.setText(this.previous_parts + this.getString() + this.next_parts);
            if (this.m.getText().length() > 0) {
                goText.last_message = new Message(this.m);
                goText.last_message.saveToAutoLast();
                if (this.m.getType() == 1) {
                    new Utils.ConfirmationAlert(this, "Do you want to overwrite the saved message? Yes to do it, No to save as new one.", 1);
                } else {
                    int n = this.m.saveMessage();
                    this.processSaveResponse(n);
                }
            } else {
                Utils.popup("Warning", "It is not possible to save empty text!", AlertType.WARNING);
            }
        } else if (command == this.command_next) {
            this.m.setText(this.previous_parts + this.getString() + this.next_parts);
            this.setPart(this.current_edited_partN + 1);
            this.start();
        } else if (command == this.command_prev) {
            this.m.setText(this.previous_parts + this.getString() + this.next_parts);
            this.setPart(this.current_edited_partN - 1);
            this.start();
        }
    }

    private void processSaveResponse(int n) {
        if (n > 0) {
            Utils.popup("OK", "Text saved!", AlertType.INFO, (Displayable)this);
        } else if (n == -2) {
            StringBuffer stringBuffer = new StringBuffer().append("It is not possible to save more than  ");
            this.m.getClass();
            Utils.popup("Warning", stringBuffer.append(10).append(" ").append("messages").toString(), AlertType.WARNING, (Displayable)this);
        } else {
            Utils.popup("Error", "Error while saving text.", AlertType.ERROR, (Displayable)this);
        }
    }

    public void doOk(int n) {
        if (n == 0) {
            this.setString("");
            this.previous_parts = "";
            this.next_parts = "";
            this.m.setText("");
            Utils.safeStartAutoLastMessageSaver(this, this.m);
            this.safeStartCharCounter();
            this.setPart(1);
            this.show();
        } else if (n == 1) {
            int n2 = this.m.saveMessage();
            this.processSaveResponse(n2);
        }
    }

    public void doKo(int n) {
        if (n == 0) {
            Utils.safeStartAutoLastMessageSaver(this, this.m);
            this.show();
        } else if (n == 1) {
            this.m.setType(0);
            int n2 = this.m.saveMessage();
            this.processSaveResponse(n2);
        }
    }

    public int getMaxChar() {
        return this.getMaxSize();
    }

    public int getMaxCharsWithSign() {
        if (!this.isLastPart) {
            return this.getMaxChar() - this.current_max_chars;
        }
        return this.current_max_chars - 50 - (this.s.getStringConfig(13).length() > 0 ? this.s.getStringConfig(13).length() + 1 : 0);
    }

    public void safeQuitCharCounter() {
        if (this.counterThread != null && this.counterThread.isAlive()) {
            this.counterThread.quit();
            try {
                this.counterThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void safeStartCharCounter() {
        if (goText.options.getCharsCounter() > 0) {
            this.safeQuitCharCounter();
            this.counterThread = new CharsCounter();
            this.counterThread.start();
        }
    }

    private class DevMaxCharGetter
    extends TextBox {
        public DevMaxCharGetter() {
            super("Write", "", 65535, 0);
            this.setMaxSize(65535);
        }

        public int getDeviceMaxChar() {
            if (this.getMaxSize() <= 65535) {
                return this.getMaxSize();
            }
            return 65535;
        }
    }

    private class RecipientsForm
    extends Form
    implements CommandListener,
    ItemStateListener {
        private TextField[] textfield;
        private Command command_ref;
        private Command command_text;
        private Command command_addr;
        private Command command_send;

        public RecipientsForm() {
            super("Recipients");
            this.start();
        }

        private void start() {
            this.textfield = new TextField[FormCompose.this.s.getIntConfig(8)];
            switch (FormCompose.this.s.getIntConfig(12)) {
                case 0: {
                    for (int i = 0; i < this.textfield.length; ++i) {
                        try {
                            this.textfield[i] = new TextField("Recipients " + (i + 1), FormCompose.this.m.getRecipientsArray()[i], 50, 1);
                        }
                        catch (Exception exception) {
                            this.textfield[i] = new TextField("Recipients " + (i + 1), "", 50, 1);
                        }
                        this.append((Item)this.textfield[i]);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.textfield.length; ++i) {
                        try {
                            this.textfield[i] = new TextField("Recipients " + (i + 1), FormCompose.this.m.getRecipientsArray()[i], 20, 3);
                        }
                        catch (Exception exception) {
                            this.textfield[i] = new TextField("Recipients " + (i + 1), "", 20, 3);
                        }
                        this.append((Item)this.textfield[i]);
                    }
                    break;
                }
                case 2: {
                    int[][] nArray = new int[2][2];
                    nArray[0][0] = 3;
                    nArray[0][1] = 13;
                    nArray[1][0] = 1;
                    nArray[1][1] = 50;
                    String[] stringArray = new String[]{"Recipients", "Recipients (Email :)"};
                    int n = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        try {
                            this.textfield[i] = new TextField(stringArray[i] + " " + (i + 1), FormCompose.this.m.getRecipientsArray()[i - n], nArray[i][1], nArray[i][0]);
                        }
                        catch (Exception exception) {
                            this.textfield[i] = new TextField(stringArray[i] + " " + (i + 1), "", nArray[i][1], nArray[i][0]);
                            ++n;
                        }
                        this.append((Item)this.textfield[i]);
                    }
                    break;
                }
            }
            this.command_send = new Command("Send", 1, 1);
            this.command_text = new Command("Text/Back", 2, 2);
            this.command_ref = new Command("Reset", 1, 3);
            this.command_addr = new Command("Contacts", 1, 4);
            this.addCommand(this.command_send);
            this.addCommand(this.command_text);
            this.addCommand(this.command_ref);
            this.addCommand(this.command_addr);
            this.setCommandListener(this);
            this.setItemStateListener(this);
            this.show();
        }

        public void show() {
            goText.display.setCurrent((Displayable)this);
        }

        public void itemStateChanged(Item item) {
            if (FormCompose.this.s.getIntConfig(12) == 2) {
                if (((TextField)item).equals(this.textfield[0])) {
                    this.textfield[1].setString("");
                } else if (((TextField)item).equals(this.textfield[1])) {
                    this.textfield[0].setString("");
                }
            }
        }

        private int insNumOrMail() {
            int n = 0;
            n += this.insNumbers(0, 1);
            return n += this.insEmail(1, 2);
        }

        private int insNumbers() {
            return this.insNumbers(0, this.textfield.length);
        }

        private int insNumbers(int n, int n2) {
            int n3 = 0;
            while (n < n2) {
                if (this.textfield[n].getString().length() > 0) {
                    if (this.textfield[n].getString().compareTo("") != 0 && !this.textfield[n].getString().startsWith("+") && !this.textfield[n].getString().startsWith("00")) {
                        this.textfield[n].setString(goText.options.getDefPrefix() + this.textfield[n].getString());
                    }
                    if (FormCompose.this.m.addNumericRecipient(this.textfield[n].getString()) < 0) {
                        this.textfield[n].setString("");
                        ++n3;
                    }
                }
                ++n;
            }
            return n3;
        }

        private int insEmail() {
            return this.insEmail(0, this.textfield.length);
        }

        private int insEmail(int n, int n2) {
            int n3 = 0;
            while (n < n2) {
                if (this.textfield[n].getString().length() > 0 && FormCompose.this.m.addEmailRecipient(this.textfield[n].getString()) < 0) {
                    this.textfield[n].setString("");
                    ++n3;
                }
                ++n;
            }
            return n3;
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.command_ref) {
                for (int i = 0; i < this.textfield.length; ++i) {
                    this.textfield[i].setString("");
                }
            } else if (command == this.command_send) {
                FormCompose.this.m.resetRecipients();
                int n = 0;
                switch (FormCompose.this.s.getIntConfig(12)) {
                    case 0: {
                        n = this.insEmail();
                        break;
                    }
                    case 1: {
                        n = this.insNumbers();
                        break;
                    }
                    case 2: {
                        n = this.insNumOrMail();
                    }
                }
                if (n > 0) {
                    Utils.popup("Warning", "Wrong recipient", AlertType.WARNING);
                } else {
                    this.doSendMessage();
                }
            } else if (command == this.command_text) {
                FormCompose.this.m.resetRecipients();
                int n = 0;
                switch (FormCompose.this.s.getIntConfig(12)) {
                    case 0: {
                        n = this.insEmail();
                        break;
                    }
                    case 1: {
                        n = this.insNumbers();
                        break;
                    }
                    case 2: {
                        n = this.insNumOrMail();
                    }
                }
                if (n > 0) {
                    Utils.popup("Warning", "Wrong recipient", AlertType.WARNING);
                } else {
                    FormCompose.this.setPart(1);
                }
                FormCompose.this.start();
            } else if (command == this.command_addr) {
                FormCompose.this.m.resetRecipients();
                int n = 0;
                switch (FormCompose.this.s.getIntConfig(12)) {
                    case 0: {
                        n = this.insEmail();
                        break;
                    }
                    case 1: {
                        n = this.insNumbers();
                        break;
                    }
                    case 2: {
                        n = this.insNumOrMail();
                    }
                }
                if (n > 0) {
                    Utils.popup("Warning", "Name already in use(" + n + ").", AlertType.WARNING);
                } else {
                    new ListSelectContact();
                }
            }
        }

        private void doSendMessage() {
            if (FormCompose.this.m.isReadyToSend(FormCompose.this.s)) {
                goText.last_message = new Message(FormCompose.this.m);
                goText.last_message.saveToAutoLast();
                new FormSend(FormCompose.this.s, FormCompose.this.m);
            } else {
                Utils.popup("Warning", "Text or Address typed wrong!", AlertType.WARNING);
            }
        }

        public class ListSelectContact
        extends List
        implements CommandListener {
            private Command command_back;

            public ListSelectContact() {
                super("Contacts", 3);
                this.start();
            }

            private void start() {
                this.setTitle("Contacts: " + goText.contacts.length);
                if (goText.contacts.length == 0) {
                    this.setTicker(new Ticker("No contacts. Press NEW to insert a new contact"));
                } else {
                    Image image = null;
                    Image image2 = null;
                    try {
                        image = Image.createImage((String)"/img/contact.png");
                        image2 = Image.createImage((String)"/img/group.png");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (int i = 0; i < goText.contacts.length; ++i) {
                        if (goText.contacts[i].isGroup()) {
                            this.append(goText.contacts[i].getName(), image2);
                            continue;
                        }
                        this.append(goText.contacts[i].getName(), image);
                    }
                }
                this.command_back = new Command("Back", 2, 5);
                this.addCommand(this.command_back);
                this.setCommandListener(this);
                this.show();
            }

            public void show() {
                goText.display.setCurrent((Displayable)this);
            }

            public void commandAction(Command command, Displayable displayable) {
                if (command == List.SELECT_COMMAND) {
                    if (this.getSelectedIndex() >= 0) {
                        if (FormCompose.this.s.getIntConfig(12) == 1 || FormCompose.this.s.getIntConfig(12) == 2) {
                            String[] stringArray = Utils.splitString(goText.contacts[this.getSelectedIndex()].getNumber(), ";");
                            for (int i = 0; i < stringArray.length; ++i) {
                                FormCompose.this.m.addNumericRecipient(stringArray[i]);
                            }
                        }
                        if (FormCompose.this.s.getIntConfig(12) == 0 || FormCompose.this.s.getIntConfig(12) == 2) {
                            FormCompose.this.m.addEmailRecipient(goText.contacts[this.getSelectedIndex()].getEmail());
                        }
                    }
                    new RecipientsForm();
                } else if (command == this.command_back) {
                    RecipientsForm.this.show();
                }
            }
        }
    }

    public class FormCompressText
    extends Form
    implements CommandListener,
    ItemStateListener {
        private Command command_back;
        private Command command_ok;
        private StringItem stringitem_text;
        private Gauge gauge_compressor;
        private int compression_level = 0;

        public FormCompressText() {
            super("Compress");
            this.start();
        }

        private void start() {
            this.gauge_compressor = new Gauge("Compression level", true, 5, this.compression_level);
            this.append((Item)this.gauge_compressor);
            String string = Lang.compressText(FormCompose.this.m.getText(), this.compression_level);
            this.stringitem_text = new StringItem("Text (" + Utils.realStringLen(string, FormCompose.this.s) + "/" + FormCompose.this.s.getMaxCharsWithSign() + "):", string);
            this.append((Item)this.stringitem_text);
            this.command_ok = new Command("Ok", 1, 1);
            this.command_back = new Command("Back", 2, 2);
            this.addCommand(this.command_ok);
            this.addCommand(this.command_back);
            this.setCommandListener(this);
            this.setItemStateListener(this);
            this.show();
        }

        public void show() {
            goText.display.setCurrent((Displayable)this);
        }

        public void itemStateChanged(Item item) {
            if (item == this.gauge_compressor) {
                String string = Lang.compressText(FormCompose.this.m.getText(), this.gauge_compressor.getValue());
                this.stringitem_text.setLabel("Text (" + Utils.realStringLen(string, FormCompose.this.s) + "/" + FormCompose.this.s.getMaxCharsWithSign() + "):");
                this.stringitem_text.setText(string);
                this.show();
            }
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.command_back) {
                FormCompose.this.show();
                Utils.safeStartAutoLastMessageSaver(FormCompose.this, FormCompose.this.m);
            } else if (command == this.command_ok) {
                this.compression_level = this.gauge_compressor.getValue();
                FormCompose.this.m.setText(Lang.compressText(FormCompose.this.m.getText(), this.compression_level));
                FormCompose.this.setPart(FormCompose.this.current_edited_partN);
                FormCompose.this.start();
            }
        }
    }

    private class CharsCounter
    extends Thread {
        private boolean stop = false;

        private CharsCounter() {
        }

        public void run() {
            int n = Utils.realStringLen(FormCompose.this.previous_parts, FormCompose.this.s) + Utils.realStringLen(FormCompose.this.next_parts, FormCompose.this.s);
            int n2 = 0;
            while (!this.stop) {
                if (n2 >= 10) {
                    int n3 = 0;
                    if (FormCompose.this.isShown()) {
                        n3 = Utils.realStringLen(FormCompose.this.getString(), FormCompose.this.s);
                    }
                    if (FormCompose.this.available_chars != FormCompose.this.s.getMaxCharsWithSign()) {
                        FormCompose.this.setTitle("p" + FormCompose.this.current_edited_partN + "/" + FormCompose.this.total_partN + " " + n3 + "/" + FormCompose.this.available_chars + " [" + (n + n3) + "/" + FormCompose.this.s.getMaxCharsWithSign() + "]");
                    } else {
                        FormCompose.this.setTitle(n3 + "/" + FormCompose.this.available_chars);
                    }
                    n2 = 0;
                }
                try {
                    CharsCounter.sleep(100L);
                    ++n2;
                }
                catch (Exception exception) {}
            }
        }

        public void quit() {
            goText.log("Program asked char counter to quit...");
            this.stop = true;
        }
    }

    private class SubstituteChars
    extends Thread {
        private boolean stop = false;
        private boolean pause = true;

        private SubstituteChars() {
        }

        public void run() {
            int n;
            String string = "|";
            String[] stringArray = Utils.splitString(FormCompose.this.s.getStringConfig(14), string);
            String[] stringArray2 = Utils.splitString(FormCompose.this.s.getStringConfig(15), string);
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equals("\\n")) continue;
                stringArray[n] = "\n";
            }
            if (stringArray.length < 1 || stringArray2.length < 1 || stringArray.length != stringArray2.length) {
                return;
            }
            int n2 = stringArray.length < 3 ? 1500 : 750;
            n = 0;
            while (!this.stop) {
                if (!this.pause) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (FormCompose.this.getString().indexOf(stringArray[i]) == -1) continue;
                        FormCompose.this.setString(Utils.replaceString(FormCompose.this.getString(), stringArray[i], stringArray2[i], false));
                    }
                    try {
                        SubstituteChars.sleep(n2);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    if (FormCompose.this != goText.display.getCurrent()) {
                        this.pause = true;
                        goText.log("pausing substitution, FormCompose not accessible anymore...");
                        if (++n == 9) {
                            this.stop = true;
                        }
                        Thread.sleep(1000L);
                        continue;
                    }
                    goText.log("resuming substitution!");
                    this.pause = false;
                }
                catch (Exception exception) {}
            }
            goText.log("exiting substitution");
        }

        public void quit() {
            goText.log("Program asked substitution to quit...");
            this.stop = true;
        }
    }
}

