/*
 * Decompiled with CFR 0.152.
 */
package org.gotext;

import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import org.gotext.RSUtils;
import org.gotext.Utils;
import org.gotext.goText;

public class Contact {
    static final String RN = "_contacts";
    public static final int MAX_MEM_CONTACTS = 30;
    String contactString;
    String name;
    String number;
    String email;

    public Contact(String string) {
        this.contactString = string;
        this.name = Utils.getTag(string, "na");
        this.number = Utils.getTag(string, "nu");
        this.email = Utils.getTag(string, "em");
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isGroup() {
        return this.number.indexOf(";") > 0;
    }

    public int set(String string, String string2, String string3) {
        String string4 = "<na>" + string + "</na>";
        string4 = string2.startsWith("+") || string2.startsWith("00") ? string4 + "<nu>" + string2 + "</nu>" : (string2.compareTo("") != 0 ? string4 + "<nu>" + goText.options.getDefPrefix() + string2 + "</nu>" : string4 + "<nu></nu>");
        string4 = string4 + "<em>" + string3 + "</em>";
        int n = this.getRmsId();
        if (!this.getName().equals(string) && Contact.existContactName(string)) {
            return -2;
        }
        return Contact.modContact(string4, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRmsId() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RN, (boolean)true);
            RSUtils rSUtils = new RSUtils();
            rSUtils.getClass();
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords((RecordFilter)new RSUtils.FilterByString(rSUtils, this.contactString), null, true);
            if (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                return n;
            }
            int n = -1;
            return n;
        }
        catch (Exception exception) {
            int n = -2;
            return n;
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {}
        }
    }

    public static int insert(String string, String string2, String string3) {
        if (goText.contacts.length >= 30) {
            return -3;
        }
        if (Contact.existContactName(string)) {
            return -2;
        }
        String string4 = "<na>" + string + "</na>";
        string4 = string2.startsWith("+") || string2.startsWith("00") ? string4 + "<nu>" + string2 + "</nu>" : (string2.compareTo("") != 0 ? string4 + "<nu>" + goText.options.getDefPrefix() + string2 + "</nu>" : string4 + "<nu></nu>");
        string4 = string4 + "<em>" + string3 + "</em>";
        return Contact.insContact(string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Contact[] contactsArray() {
        RecordStore recordStore = null;
        int n = 0;
        Contact[] contactArray = new Contact[]{};
        try {
            recordStore = RecordStore.openRecordStore((String)RN, (boolean)true);
            n = recordStore.getNumRecords();
            if (n > 0) {
                contactArray = new Contact[n];
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, (RecordComparator)new RSUtils.OrderByString(new RSUtils()), true);
                int n2 = 0;
                while (recordEnumeration.hasNextElement()) {
                    contactArray[n2] = new Contact(new String(recordEnumeration.nextRecord()));
                    ++n2;
                }
                recordEnumeration.destroy();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {}
        }
        return contactArray;
    }

    private static boolean isValidContactString(String string) {
        if (string.indexOf("<na>") < 0 || string.indexOf("</na>") < 0 || string.indexOf("<nu>") < 0 || string.indexOf("</nu>") < 0 || string.indexOf("<em>") < 0 || string.indexOf("</em>") < 0) {
            return false;
        }
        if (Utils.getTag(string, "na").length() <= 0) {
            return false;
        }
        return Utils.getTag(string, "nu").length() > 0 || Utils.getTag(string, "em").length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int insContact(String string) {
        int n = 0;
        RecordStore recordStore = null;
        if (Contact.isValidContactString(string)) {
            try {
                recordStore = RecordStore.openRecordStore((String)RN, (boolean)true);
                n = recordStore.addRecord(string.getBytes(), 0, string.getBytes().length);
            }
            catch (Exception exception) {
                n = -1;
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
                Contact.generateContactsArray();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int modContact(String string, int n) {
        int n2 = 0;
        RecordStore recordStore = null;
        if (Contact.isValidContactString(string)) {
            try {
                recordStore = RecordStore.openRecordStore((String)RN, (boolean)true);
                recordStore.setRecord(n, string.getBytes(), 0, string.getBytes().length);
                n2 = n;
            }
            catch (Exception exception) {
                n2 = -1;
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
                Contact.generateContactsArray();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int delContact(int n) {
        int n2 = 0;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RN, (boolean)false);
            recordStore.deleteRecord(n);
            n2 = n;
        }
        catch (Exception exception) {
            n2 = -1;
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {}
            Contact.generateContactsArray();
        }
        return n2;
    }

    public static boolean existContactName(String string) {
        for (int i = 0; i < goText.contacts.length; ++i) {
            if (!goText.contacts[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static void generateContactsArray() {
        goText.contacts = Contact.contactsArray();
    }
}

