/*
 * Decompiled with CFR 0.152.
 */
package org.gotext;

import java.io.DataInputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import org.gotext.Utils;
import org.gotext.goText;

public abstract class ConnectionManager
implements Runnable {
    private boolean redirected = false;
    private byte[] datas;
    private HttpConnection c;
    private DataInputStream is;
    private OutputStream os;
    private String datastring;
    private String address;
    private boolean sendFinished;
    protected boolean hasbeenredirected;
    protected String cookie;
    protected int sent = 0;
    protected int received = 0;
    protected static final String DUMMYPAGE = "http://www.gotext.org/pub/empty.htm";
    protected boolean intelligentRedir;
    public static final int PROGRESS_STATUS = 0;
    public static final int PROGRESS_BYTEIN = 1;
    public static final int PROGRESS_BYTEOUT = 2;

    public ConnectionManager(String string, String string2) {
        this.datastring = string;
        this.datastring = this.datastring + "&spv=2.0&lang=en";
        this.address = string2;
        this.hasbeenredirected = false;
        this.sendFinished = false;
        this.intelligentRedir = goText.options.getHasProxyRedirect() == 1 && string.indexOf("ic=") != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.cookie = this.getStoredCookie();
        String string = "";
        byte[] byArray = null;
        try {
            byArray = this.connect();
        }
        catch (GPRSException gPRSException) {
            string = "<num>-1</num><txt>" + gPRSException.getMessage() + "</txt>";
        }
        catch (ServiceException serviceException) {
            string = "<num>-2</num><txt>" + serviceException.getMessage() + "</txt>";
        }
        catch (Exception exception) {
            string = "<num>-3</num><txt>" + exception.getMessage() + "</txt>";
        }
        finally {
            this.sendFinished = true;
            this.updateConnectionStatus("finished");
            if (this.hasbeenredirected) {
                goText.options.setHasProxyRedirect(1);
            } else if (goText.isfirstconnection) {
                goText.options.setHasProxyRedirect(0);
            }
            goText.isfirstconnection = false;
            this.handleReply(byArray, string);
        }
    }

    protected void handleReply(byte[] byArray, String string) {
        if (byArray != null) {
            string = new String(byArray);
        }
        this.checkAnswer(string);
    }

    private byte[] connect() throws Exception {
        this.datas = null;
        String string = "";
        String string2 = this.address;
        this.setProgressText("sending\n", 0);
        for (int i = 0; i < 3; ++i) {
            block47: {
                try {
                    this.c = null;
                    this.is = null;
                    this.os = null;
                    this.updateConnectionStatus("sending");
                    if (this.intelligentRedir && i == 0) {
                        this.address = DUMMYPAGE;
                    } else if (this.intelligentRedir && i > 0) {
                        this.address = string2;
                    }
                    if (goText.options.getConnectionMethod() == 1 || !this.address.startsWith(string2)) {
                        if (this.address.startsWith(string2)) {
                            this.address = this.address + "?" + this.datastring;
                            this.sent += this.datastring.length();
                        }
                        this.sent += this.address.length();
                        this.address = Utils.replaceString(this.address, " ", "%20", false);
                        this.address = Utils.replaceString(this.address, "\n", "%0A", false);
                        try {
                            goText.log("GET (" + i + "): " + this.address);
                            this.c = (HttpConnection)Connector.open((String)this.address);
                            if (this.cookie != null && this.cookie.length() > 0) {
                                this.c.setRequestProperty("Cookie", this.cookie);
                            }
                            this.c.setRequestProperty("Connection", "Close");
                        }
                        catch (SecurityException securityException) {
                            throw new GPRSException("You have to allow gprs connection to send a message!");
                        }
                        catch (Exception exception) {
                            throw new GPRSException("Starting connection error (GET): " + exception.toString());
                        }
                    }
                    byte[] byArray = this.datastring.getBytes();
                    try {
                        goText.log("POST (" + i + "): " + this.address);
                        this.c = (HttpConnection)Connector.open((String)this.address, (int)3);
                        this.c.setRequestMethod("POST");
                        if (this.cookie != null && this.cookie.length() > 0) {
                            this.c.setRequestProperty("Cookie", this.cookie);
                        }
                        this.c.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        this.c.setRequestProperty("Content-Length", String.valueOf(byArray.length));
                        this.c.setRequestProperty("Connection", "Close");
                    }
                    catch (SecurityException securityException) {
                        throw new GPRSException("You have to allow gprs connection to send a message!");
                    }
                    catch (Exception exception) {
                        throw new GPRSException("Starting connection error (POST): " + exception.toString());
                    }
                    this.updateConnectionStatus("sending");
                    try {
                        this.os = this.c.openOutputStream();
                        this.os.write(byArray);
                        this.sent += this.datastring.length() + this.address.length();
                    }
                    catch (Exception exception) {
                        throw new GPRSException("Writing data error: " + exception.toString());
                    }
                    this.updateConnectionStatus("sending");
                    try {
                        int n = this.c.getResponseCode();
                        goText.log("rc:" + n);
                        this.cookie = this.c.getHeaderField("cookie");
                        goText.log("cookie:" + this.cookie);
                        if (this.cookie != null && this.cookie.length() > 0) {
                            this.cookie = this.cookie.replace(';', ' ').trim();
                            this.setCookieToStore(this.cookie);
                        } else if (this.cookie == null || this.cookie.length() == 0) {
                            this.cookie = this.getStoredCookie();
                        }
                        if (n == 200) {
                            this.redirected = false;
                            try {
                                int n2 = (int)this.c.getLength();
                                goText.log("len: " + n2);
                                if (n2 > 0) {
                                    this.is = this.c.openDataInputStream();
                                    this.datas = new byte[n2];
                                    this.is.readFully(this.datas);
                                } else {
                                    int n3;
                                    this.is = this.c.openDataInputStream();
                                    while ((n3 = this.is.read()) != -1) {
                                        string = string + (char)n3;
                                    }
                                    this.datas = new byte[string.length()];
                                    this.datas = string.getBytes();
                                }
                                this.received += this.datas.length;
                                break block47;
                            }
                            catch (Exception exception) {
                                throw new GPRSException("Reading data error: " + exception.getMessage());
                            }
                        }
                        if (n == 302) {
                            try {
                                this.address = this.c.getHeaderField("Location");
                                goText.log("Redirect address:" + this.address);
                                this.received += this.address.length();
                                this.redirected = true;
                                break block47;
                            }
                            catch (Exception exception) {
                                throw new GPRSException("Reading data error: " + exception.getMessage());
                            }
                        }
                        if (n == 404) {
                            throw new GPRSException("Service url is not valid.");
                        }
                        if (n == 500) {
                            throw new ServiceException("Server has encountered an error while executing the service. \nThere is a temporary problem on the SMS server, or the service one.");
                        }
                        throw new ServiceException("Server Error. Response code: " + n);
                    }
                    catch (Exception exception) {
                        goText.log(exception.toString());
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.updateConnectionStatus("closing");
            if (this.os != null) {
                try {
                    this.os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.c != null) {
                try {
                    this.c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.redirected || this.intelligentRedir && i == 0 || !this.redirected && i > 0 && this.address.compareTo(string2) != 0) {
                if (this.redirected && i == 0 && this.address.compareTo(DUMMYPAGE) != 0) {
                    this.address = DUMMYPAGE;
                    continue;
                }
                this.address = string2;
                continue;
            }
            goText.log("No proxy, exiting loop");
            break;
        }
        return this.datas;
    }

    private void updateConnectionStatus(String string) {
        if (this.redirected) {
            this.hasbeenredirected = true;
        }
        String string2 = "";
        if (this.hasbeenredirected && this.intelligentRedir) {
            string2 = " (i) ";
        } else if (!this.hasbeenredirected && this.intelligentRedir) {
            string2 = " (i-) ";
        } else if (this.hasbeenredirected && !this.intelligentRedir) {
            string2 = " (r) ";
        }
        this.setProgressText(string + string2 + "\n", 0);
        this.setProgressText(this.sent + " b\n", 2);
        try {
            this.setProgressText(this.received + " b\n", 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.showScreen();
    }

    protected abstract void showScreen();

    protected abstract void setProgressText(String var1, int var2);

    protected abstract void setCookieToStore(String var1);

    protected abstract String getStoredCookie();

    protected abstract void checkAnswer(String var1);

    protected boolean isSendFinished() {
        return this.sendFinished;
    }

    public class GPRSException
    extends Exception {
        public GPRSException(String string) {
            super(string);
        }
    }

    public class ServiceException
    extends Exception {
        public ServiceException(String string) {
            super(string);
        }
    }
}

